# LiteLoaderQQNT - anti-recall

LiteLoaderQQNT 插件，用于比较完善的防撤回。
使用前需要安装 [LiteLoaderQQNT](https://github.com/mo-jinran/LiteLoaderQQNT) ，并在 QQNT 新版上使用。

建议加入更新日志频道，接收最新更新和使用提示 [https://t.me/llqqnt_xh](https://t.me/llqqnt_xh) 。

因工作原因暂无时间更新，如有能帮忙更新的欢迎提交PR。
目前支持的版本：小于等于 9.9.7-21453，大于这个版本未经测试不做任何保证，如升级 QQ 后遇到问题建议降级，感谢理解。

## 使用方法

*建议从 `LiteLoaderQQNT` 应用商店中直接下载安装，方便快捷。*（新版本 1.0 `LiteLoaderQQNT` 没有插件商店了，请遵循下面的手动安装方法）

**手动安装**：请前往[版本发布页面](https://github.com/xh321/LiteLoaderQQNT-Anti-Recall/releases)下载最新版压缩包（`qq-anti-recall.zip`），在`LiteLoaderQQNT数据目录/plugins/`下面新建文件夹（名称任意，建议为插件名称），将插件压缩包里的内容解压进去，重启QQNT即可。

直接克隆源码的话，记得需要手动进行 `npm install`。

**版本不兼容提示**：从 0.2.29 起，插件已适配 1.0 版本以上 `LiteLoaderQQNT` 框架，同时不再兼容旧版框架，请遵循[安装方法](https://liteloaderqqnt.github.io/guide/install.html)更新框架。

**版本提示**：从 0.2.35 起，自旧版本升级上来的用户会丢失配置和已撤回数据库，需要手动迁移，这是因为之前的数据目录写入错误。迁移过程：把 `LiteLoaderQQNT数据目录/qq-recalled-db` 文件夹移动到 `LiteLoaderQQNT数据目录/anti_recall` 文件夹内即可（最终路径： `LiteLoaderQQNT数据目录/anti_recall/qq-recalled-db`。配置文件不建议迁移，可能已经被其他配置文件覆盖，建议重新配置插件（一共也没几个配置项目）。

注意：如果你是从旧版更新到新版（1.0）框架后，需要把 `LiteLoaderQQNT` 数据目录中的 plugins_data 文件夹重命名为 data，否则之前的记录和配置文件会丢失。（如果仍然丢失就没办法了）


## 什么情况下反撤回会失效

1. QQ 接到消息时已经被撤回（只接到了撤回的消息）。
2. QQ 未在线时接到的消息（上线后已经被撤回）。
3. 从接到某条消息开始到这条消息撤回，还收到了超过 `MaxMsgSaveLimit（内存中消息最多缓存条数）` 条消息（可以在配置界面里配置）。
4. 插件出现错误。

## 重启 QQ 反撤回失效？

请使用命令行运行 QQ，并观察日志输出。

如果出现：数据库打开失败的提示，并且下面的 cause 类似于

```
cause: [Error: IO error: LockFile <LiteLoaderQQNT数据目录>\data\qq-recalled-db/LOCK...]
```

可能是你之前的 QQ 退出不完全，或者你开了两个 QQ。

请完全关闭 QQ 进程，并重试。若还不行，可能是数据库文件损坏，考虑清空上面的路径（<LiteLoaderQQNT数据目录>\data\qq-recalled-db）中的 LOCK 文件，若还不行，清空所有文件（会导致之前反撤回内容丢失）。



## 太长不看版

在 NTQQ 打开期间无论怎样操作，**反撤回均能生效**。

若开启数据库储存（**默认关闭**，请前往配置界面手动开启），NTQQ 重启后可恢复已撤回的消息，目前已测试文本、表情、图片、转发消息均能正常恢复；文件若没下载则不能打开，但还能看见文件消息本身；其他消息类型未测试，不提供保证。

若不满意撤回的颜色、阴影和提示，也请前往配置界面手动调整。

若反撤回消息太多，累积在数据库里可能造成加载卡顿，现在已经做了优化，一般来说不需要清理，但如果觉得卡顿，如有必要，还是可以**隔一段时间**通过插件配置界面清理一次已储存的消息。

## 详细说明

所有被撤回的消息会被带上红框，下方会出现“已撤回”的小提示（均可通过配置关闭）。**重新进消息界面已撤回的消息仍然可以正常显示。**

**使用 LevelDB 进行数据持久化储存**，默认**不**启用，需要手动去设置里开启。如果不开启，重启 QQ 消息会丢失。若开启，当前版本重启 QQ 后**已能恢复文字、图片、转发和表情消息**，其他消息不提供保证，若不能恢复请提 `ISSUE`。

`LevelDB` 有时候启动的时候会加载失败，导致无法加载反撤回数据库内容。如果发现之前的反撤回失效，重启 QQ 一般都能解决（目前正在尽力避免这种问题）。

如果你需要调整撤回样式，请前往插件的设置界面，手动修改调整。

不建议手动修改配置文件，修改后不会实时生效（需要重启 QQ ），建议用配置界面修改。



现在，即使图片在撤回之前未打开过，撤回后也能继续查看了，并且不止缩略图，点开看也是可以的！即使图片显示为灰色的损坏样式，你也可以双击试试能不能打开看。

但是如果不是在眼前撤回的，而是撤回后你才点进聊天界面去看的，图片仍然会转圈一段时间（请耐心等待），猜测因为 QQ 会先检查图片是否存在，撤回后还没下载当然不存在，所以转圈；等插件下载好图片后，需要等待 QQ 重新检查，才能显示图片。

图片如果撤回太快，反撤回后有可能会一直加载不出来，这个可能是图片已经从服务器上删除了，这种情况下，**无法恢复**。

## 原理介绍

**之前版本（过时）：** 为什么在简介里说是简易的呢？因为这个防撤回原理是通过拦截撤回消息的 IPC，这样消息就不会被删除。可是，若重新打开消息界面，NTQQ 似乎会重新向逻辑层拉取一次消息（旧版 QQ 的防撤回直接从通信上就拦截了撤回包，所以没有这个问题；而本插件仅拦截到了渲染层的 IPC，逻辑层还是一个黑盒），所以导致消息仍然被撤回了。

**现在版本的变更：** 在接到消息后会将消息存于内存中，进入消息界面后，若发现撤回会拦截撤回包，并显示红色边框以及给文字附加删除线。若重新进入消息页面，会遍历消息列表，若发现撤回的提示，会寻找之前保存过的消息，若找到，则将撤回提示替换为之前保存的消息，并显示红色边框以及给文字附加删除线；若未找到，则仍然显示撤回提示。这样，重进消息界面**仍然可以正确反撤回**（包括打开独立聊天界面**也可以**）。

- 为避免太占内存，内存中缓存消息的上限默认为 10000 条。如有需要，可前往插件设置界面修改。这个值的意义是，假设默认最多存 10000 条，那么总接到消息的 10000 条之前的消息若被撤回则无法恢复。**不过，若一条消息在撤回后你回去看了，并且反撤回生效（也就是只要你看到了这条消息出现红框和删除线），则这条消息会被额外储存到专门的“已撤回消息数组”中，（若开启数据库，也会同时存进数据库），这个数组没有容量上限，不会被本限制所约束。**
- 为避免可能存在的并发问题，消息超过上述限制后，每次接到消息后默认会删除内存缓存的消息中的前 500 条，直到低于上述上限。这个 500 条你也可以通过插件设置页面来变更。建议修改为你平均每秒接到的消息数量。
- 若开启数据库储存功能，则任何撤回的消息都会存入本地的数据库（位于 LLQQNT 的插件数据目录（ `plugin_data` 里），以便于重启后读取已撤回的消息记录。数据库明文储存（后续会推出加密功能），请谨慎保管。

相关详细的原理和说明请参阅源码。

## 协议及免责

MIT | 禁止用于任何非法用途，插件开发属学习与研究目的，仅自用，未提供给任何第三方使用。任何不当使用导致的任何侵权问题责任自负。
